/*
 * CMSC 240
 * Project 2
 * 10/27/2010
 * NetBeans
 * Jeremiah Moss
 */


package cmsc420project4;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Jeremiah
 */
public class ExpressionTreeTest {

    public ExpressionTreeTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception
    {
    }

    @AfterClass
    public static void tearDownClass() throws Exception
    {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of setString method, of class ExpressionTree.
     */
    @Test
    public void testSetString()
    {
        System.out.println("setString");
        String string = "1+2";
        ExpressionTree instance = new ExpressionTree();
        instance.setString(string);
    }

    /**
     * Test of isHigherPrecedence method, of class ExpressionTree.
     */
    @Test
    public void testIsHigherPrecedence()
    {
        System.out.println("isHigherPrecedence");
        String op1 = "+";
        String op2 = "-";
        ExpressionTree instance = new ExpressionTree();
        boolean expResult = false;
        boolean result = instance.isHigherPrecedence(op1, op2);
        assertEquals(expResult, result);

        op1 = "/";
        op2 = "*";
        expResult = false;
        result = instance.isHigherPrecedence(op1, op2);
        assertEquals(expResult, result);

        op1 = "^";
        op2 = "*";
        expResult = false;
        result = instance.isHigherPrecedence(op1, op2);
        assertEquals(expResult, result);

        op1 = "*";
        op2 = "^";
        expResult = true;
        result = instance.isHigherPrecedence(op1, op2);
        assertEquals(expResult, result);

        op1 = "(";
        op2 = ")";
        expResult = false;
        result = instance.isHigherPrecedence(op1, op2);
        assertEquals(expResult, result);

    }

    /**
     * Test of getValue method, of class ExpressionTree.
     */
    @Test
    public void testGetValue()
    {
        System.out.println("getValue");
        ExpressionTree instance = new ExpressionTree();
        boolean exceptionThrown = false;

        try
        {
            instance.getValue(null);
        } catch(RuntimeException e)
        {
            exceptionThrown = true;
        }
        assertTrue(exceptionThrown==true);

        exceptionThrown = false;
        try
        {
            instance.getValue("");
        } catch(RuntimeException e)
        {
            exceptionThrown = true;
        }
        assertTrue(exceptionThrown==true);

        String operand = "0";
        double expResult = 0.0;
        double result = instance.getValue(operand);
        assertEquals(expResult, result, 0.0);

        operand = "F3";
        expResult = 0.0;
        result = instance.getValue(operand);
        assertEquals(expResult, result, 0.0);

    }

    /**
     * Test of tests method, of class ExpressionTree.
     */
    @Test
    public void testTests()
    {
        System.out.println("tests");
        String string = "";
        ExpressionTree instance = new ExpressionTree();
        Operator expResult = null;
        Operator result = instance.tests(string);
        assertEquals(expResult, result);

        // String used for testing the parser.
        String textParsing = "7*(2+5+3*2-1)";

        // The tree that should result.
        Operator operatorTest = new Operator("*");
        operatorTest.setLeft(new Operator("7"));

        Operator rightTree = new Operator("-");
        rightTree.setRight(new Operator("1"));
        operatorTest.setRight(rightTree);

        Operator RLTree = new Operator("+");
        rightTree.setLeft(RLTree);

        Operator RLLTree = new Operator("+");
        RLLTree.setLeft(new Operator("2"));
        RLLTree.setRight(new Operator("5"));

        Operator RLRTree = new Operator("*");
        RLRTree.setLeft(new Operator("3"));
        RLRTree.setRight(new Operator("2"));

        RLTree.setLeft(RLLTree);
        RLTree.setRight(RLRTree);

        System.out.println();
        System.out.print("parsed: ");
        System.out.println(instance.tests(textParsing).printTree());
        System.out.println();
        System.out.print(" ideal: ");
        System.out.println(operatorTest.printTree());
        System.out.println();

        // For some odd reason, this still fails even when trees are similar?
        assertTrue(instance.tests(textParsing).isEqual(operatorTest));

    }

    /**
     * Test of parseString method, of class ExpressionTree.
     */
    @Test
    public void testParseString()
    {
	System.out.println("parseString");
	String equation = "";
	ExpressionTree instance = new ExpressionTree();
	Operator expResult = null;
	Operator result = instance.parseString(equation);
	assertEquals(expResult, result);
	// TODO review the generated test code and remove the default call to fail.
	fail("The test case is a prototype.");
    }

}